#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TRUE 1
#define FALSE 0
#define NEDEFINISANO -1
#define INF -1

int **graf, *key;
int n, i, j, start, m;
int *prethodnik, *obidjen;
int u, v, w;
int suma, p, q;

typedef struct {
	int u;
	int v;
	int w;
} Veza;

Veza *veze;

int manji(int x, int y) {
	if (x==INF)
		return FALSE;
	if (y==INF)
		return TRUE;
	return (x<y);
}

int dajNajboljeg() {
	int minCvor = NEDEFINISANO;
	int minKey = INF;
	
	for (i=1; i<=n; i++) {
		if (!obidjen[i]) {
			if (manji(key[i],minKey))
			{
				minKey=key[i];
				minCvor = i;
			}
		}
	}
	return minCvor;
}

main() {
	
	scanf("%d%d",&n, &m);
	graf=(int **)malloc((n+1)*sizeof(int *));
	prethodnik=(int *)malloc((n+1)*sizeof(int));
	obidjen=(int *)malloc((n+1)*sizeof(int));
	key=(int *)malloc((n+1)*sizeof(int));
	veze = (Veza *)malloc((m+1)*sizeof(Veza));
	
	for (i=1; i<=n; i++) {
		graf[i]=(int *)malloc((n+1)*sizeof(int));
		prethodnik[i]=NEDEFINISANO;
		obidjen[i]=FALSE;
		key[i]=INF;
	}
	
	for (i=1; i<=n; i++)
		for (j=1; j<=n; j++)
			graf[i][j]=INF;
			
	for (i=1; i<=m; i++) {
		scanf("%d%d%d", &veze[i].u, &veze[i].v, &veze[i].w);
	}
	
	scanf("%d%d", &p, &q);
	
	for (i=1; i<=m; i++) {
		if (veze[i].w%p==0)
			veze[i].w = (veze[i].w/p - 1)*q;
		else
			veze[i].w = (veze[i].w/p)*q;
		
		u = veze[i].u;
		v = veze[i].v;
		w = veze[i].w;
		graf[u][v] = w;
		graf[v][u] = w;	
	}
	
	start = 1;
	key[start] = 0;
	
	suma = 0;
	while( (u=dajNajboljeg())!=NEDEFINISANO ) 
	{
		obidjen[u]=TRUE;
		suma += key[u];
		for (v=1; v<=n; v++) {
			if (graf[u][v]!=INF) {
				if (!obidjen[v]) {
					if ( manji(graf[u][v], key[v]))
					{
						key[v] = graf[u][v];
						prethodnik[v]=u;
					}
				}
			}
		}
	}

	printf("%d\n", suma);
}
	
			
	
			








